$(function () {

let url = 'admin/chart/usuarios'

$.get(url, function (response) {
         
    let datat = JSON.parse(response)
    
       var options = {
          series: [datat.activos, datat.inactivos],
          labels: ['Activos', 'Inactivos'],
          colors: ['#00E396', '#007BFF'],
          chart: {
          width: '100%',     
          height: '230',
          type: 'donut',
        },
        plotOptions: {
          pie: {
            startAngle: -90,
            endAngle: 270
          }
        },
        dataLabels: {
          enabled: false,
        },
        
        legend: {
          position: 'top',
          
          labels: {
             colors: '#333',
             useSeriesColors: false
            },
            
          formatter: function(val, opts) {
            return val + " - " + opts.w.globals.series[opts.seriesIndex]
          }
        },
        
        responsive: [{
          breakpoint: 480,
          options: {
            chart: {
              width: '100%',
              
            },
            legend: {
              position: 'top',
              width: '100%',
            }
          }
        }]
        
        };

        var chart = new ApexCharts(document.querySelector("#pieChart"), options);
        chart.render();
    })

})



$(function () { 
    
let ganancias = []
let volumen = []

let url = 'admin/chart/ventas'

$.get(url, function (response) {

let data = JSON.parse(response)

        
data.forEach(element => {

ganancias.push(element.ganancia)
             
});

data.forEach(element => {

volumen.push(element.total)
             
});
        
     var options = {
        series: [{
          name: 'Ganancias',
          data: ganancias
        }],
          
        chart: {
          width: '100%',
          height: '220',
          type: 'bar',
          foreColor: '#333',
        },
        plotOptions: {
          bar: {
            borderRadius: 10,
            columnWidth: '50%',
          }
        },
        dataLabels: {
          enabled: false
        },
        stroke: {
          width: 2
        },
        
        grid: {
          row: {
            colors: ['#fff', '#fff']
          }
        },
        xaxis: {
          labels: {
            rotate: -45
          },
          categories: ['Enero', 'Febrero', 'Marzo', 'Abril', 'Mayo', 'Junio',
            'Julio', 'Agosto', 'Septiembre', 'Octubre', 'Noviembre', 'Diciembre'
          ],
        },
        
        fill: {
          type: 'gradient',
          gradient: {
            shade: 'light',
            type: "horizontal",
            shadeIntensity: 0.25,
            gradientToColors: undefined,
            inverseColors: true,
            opacityFrom: 0.85,
            opacityTo: 0.85,
            stops: [50, 0, 100]
          },
        }
        };

        var chart = new ApexCharts(document.querySelector("#areaChart"), options);
        chart.render();
   })
})
 

 